function [X, support] = OMP(Y, A, s)
% Y = A * X + n 
% Using OMP to recover sparse signal X
%%% initialization
R = Y;
%%% OMP
norm_Phi = sqrt(sum(abs(A).^2, 1)).';
[Q, N] = size(A);

support = [];
for i = 1 : s 
    [~,order] = max(abs(A' * R)./norm_Phi);
    support = [support order];
    Phi_s = A(:,support);
    Temp = zeros(N,1);
    Temp(support) = pinv( Phi_s' * Phi_s )*Phi_s'*Y;
    R = Y - A*Temp;
end
% A = unique(support);
X = Temp;
